<% Option Explicit %>
<!--#include file="common.inc" -->
<%
'Buffer the response
Response.Buffer = True

'Dimension variables
Dim adoRec 			'Database Recordset Variable
Dim strName 			'Holds the Users name
Dim strEmailAddress 		'Holds the Users e-mail address
Dim strCountry 			'Holds the users country
Dim strHomepage 		'Holds the Users homepage
Dim strComments 		'Holds the Users comments
Dim dtmEntryDate 		'Holds the date the commnets where made
Dim intRecordPositionPageNum 	'Holds the record position
Dim intRecordLoopCounter 	'Loop counter for displaying the guestbook records
Dim intTotalNumGuestbookEntries 'Holds the total number of records in the database
Dim intTotalNumGuestbookPages 	'Holds the total number of pages in the database
Dim intLinkPageNum 		'Holds the page number to be linked to



'If this is the first time the page is displayed then the guestbook record position is set to page 1
If Request.QueryString("PagePosition") = "" Then
	intRecordPositionPageNum = 1

'Else the page has been displayed before so the guestbook record postion is set to the Record Position number
Else
	intRecordPositionPageNum = CInt(Request.QueryString("PagePosition"))
End If	

	
'Initialise the strAccessDB variable with the name of the Access Database
strAccessDB = "guestbook"
		
'Create recorset object
Set adoRec = Server.CreateObject("ADODB.Recordset")
	
'Initalise the strSQL variable with an SQL statement to query the database by selecting all tables ordered by the decending date
strSQL = "SELECT tblComments.* FROM tblComments ORDER BY Date DESC;"

'Set the cursor type property of the record set to dynamic so we can naviagate through the record set
adoRec.CursorType = 3
	
'Query the database
adoRec.Open strSQL, adoCon

'Set the number of records to display on each page by the constant set at the top of the script
adoRec.PageSize = intRecordsPerPage
	
'Get the guestbook record poistion to display from
If NOT adoRec.EOF Then adoRec.AbsolutePage = intRecordPositionPageNum
%>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<title>Guest Book</title>

<!-- The Web Wiz Guide ASP Guestbook is written by Bruce Corkhill 2001
    	 If you want your Guestbook then goto http://www.webwizguide.com -->

</head>
<body bgcolor="<% = strBgColour %>" text="<% = strTextColour %>" link="<% = strLinkColour %>" vlink="<% = strVisitedLinkColour %>" alink="<% = strActiveLinkColour %>">
<h1 align="center">Guestbook </h1>
<table width="90%" border="0" align="center" cellpadding="0" cellspacing="0" height="8">
  <tr valign="middle"> 
    <td height="14"> 
      <table width="98%" border="0" cellspacing="0" cellpadding="0" align="center">
        <tr> 
          <td width="70%"align="center">Welcome to the guestbook. If you would 
            like to sign the guest book then click on the link below.<br>
            <br>
            <a href="sign.asp?PagePosition=<% = intRecordPositionPageNum %>" target="_self">Sign 
            the guest book</a></td>
        </tr>
      </table>
    </td>
  </tr>
</table>
<table width="90%" border="0" align="center" cellspacing="0" cellpadding="0">
  <tr> 
    <td align="center"> 
      <%
'If there are no rcords in the database display an error message
If adoRec.EOF Then
	'Tell the user there are no records to show
	Response.Write "<br>There are no records in the guestbook database"
	Response.Write "<br>Please check back later"
	Response.End
	


'Display the guestbook
Else	
	
	'Count the number of enties in the guestbook database
	intTotalNumGuestbookEntries = adoRec.RecordCount	
	
	'Count the number of pages there are in the guestbook database calculated by the PageSize attribute set above
	intTotalNumGuestbookPages = adoRec.PageCount


	'Display the HTML number number the total number of pages and total number of records in the guestbook database
	%>
      <table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
        <tr> 
          <td align="center"> <br>
            There are 
            <% = intTotalNumGuestbookEntries %>
            guestbook entries in 
            <% = intTotalNumGuestbookPages %>
            pages and your are on page number 
            <% = intRecordPositionPageNum %>
          </td>
        </tr>
      </table>
      <br>
      <%

	'For....Next Loop to display records from the guestbook database
	For intRecordLoopCounter = 1 to intRecordsPerPage
	
		'If there are no guestbook records left to display then exit loop
		If adoRec.EOF Then Exit For
	      		
	      	'Read in the values form the database	
	      	strName = adoRec("Name")
      		strCountry = adoRec("Country")
	      	strEmailAddress = adoRec("EMail")
	      	dtmEntryDate = CDate(adoRec("Date"))
	      	strHomepage = adoRec("Homepage")
	      	strComments = adoRec("Comments")
	      
	      		      	
	      	'If there is no homepage entry to display the display no URL given	
	     	If strHomepage = "http://" then 
	     		strHomepage = "no URL given"
	     	
	     	'Else turn the URL stored in the strHomepage variable into a hyperlink
	     	Else 
	     		strHomepage = "<a href=""" & strHomepage & """ target=""_blank"">" & strHomepage & "</a>"
	     	End If
	      	
	      	
	      	'Write the HTML to the web browser to display the guestbook entries
	      	%>
      <table width="100%" border="0" cellspacing="0" cellpadding="1" align="center" bgcolor="<% = strTableBorderColour %>">
        <tr> 
          <td> 
            <table width="100%" border="0" cellpadding="2" cellspacing="0">
              <tr bgcolor="<% = strTableTitleColour %>"> 
                <td colspan="2">Comments by <a href="mailto:<% = strEmailAddress %>"> 
                  <% = strName %></a> on 
                  <% = FormatDateTime(dtmEntryDate, VbLongDate) %>
                  at 
                  <% = FormatDateTime(dtmEntryDate, VbShortTime) %>
                </td>
              </tr>
              <tr> 
                <td colspan="2" bgcolor="<% = strTableColour %>">
                  <% = strComments %>
                </td>
              </tr>
              <tr bgcolor="<% = strTableTitleColour %>"> 
                <td width="50%" align="left">
                  <% = strCountry %>
                </td>
                <td width="50%" align="right">
                  <% = strHomepage %>
                </td>
              </tr>
            </table>
          </td>
        </tr>
      </table>
      <br>
      <%      
	      		
      		'Move to the next record in the database
	   	adoRec.MoveNext
	
	'Loop back round   	
	Next
End If



'Display an HTML table with links to the other entries in the guestbook
%>
      <table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
        <tr> 
          <td> 
            <table width="100%" border="0" cellpadding="0" cellspacing="0">
              <tr> 
                <td width="50%" align="center"> 
                  <%
'If there are more pages to display then add a title to the other pages
If intRecordPositionPageNum > 1 or NOT adoRec.EOF Then
	Response.Write vbCrLf & "		Page:&nbsp;&nbsp;"
End If

'If the guestbook page number is higher than page 1 then display a back link    	
If intRecordPositionPageNum > 1 Then 
	Response.Write vbCrLf & "		 <a href=""guestbook.asp?PagePosition=" &  intRecordPositionPageNum - 1  & """ target=""_self"">&lt;&lt;&nbsp;Prev</a>&nbsp;"   	     	
End If     	


'If there are more pages to display then display links to all the pages
If intRecordPositionPageNum > 1 or NOT adoRec.EOF Then 
	
	'Display a link for each page in the guestbook     	
	For intLinkPageNum = 1 to intTotalNumGuestbookPages		
		
		'If the page to be linked to is the page displayed then don't make it a hyper-link
		If intLinkPageNum = intRecordPositionPageNum Then
			Response.Write vbCrLf & "		     " & intLinkPageNum
		Else
		
			Response.Write vbCrLf & "		     &nbsp;<a href=""guestbook.asp?PagePosition=" &  intLinkPageNum  & """ target=""_self"">" & intLinkPageNum & "</a>&nbsp;"			
		End If
	Next
End If


'If it is Not the End of the guestbook entries then display a next link for the next guestbook page      	
If NOT adoRec.EOF then   	
	Response.Write vbCrLf & "		&nbsp;<a href=""guestbook.asp?PagePosition=" &  intRecordPositionPageNum + 1  & """ target=""_self"">Next&nbsp;&gt;&gt;</a>"	   	
End If      	


'Finsh HTML the table 
%>
                </td>
              </tr>
            </table>
          </td>
        </tr>
      </table>
      <% 

'Reset Server Variables	
Set adoCon = Nothing
Set adoRec = Nothing

%>
    </td>
  </tr>
</table>
<div align="center"><br>
  <a href="http://www.webwizguide.com" target="_blank"><img src="web_wiz_guide.gif" width="100" height="30" border="0" alt="Web Wiz Guide!"></a> 
  <br>
</div>
</body>
</html>